Imports System.Data


Partial Class ContentFiles_ChatWindow
    Inherits System.Web.UI.Page
    Implements System.Web.UI.ICallbackEventHandler

    ''' <summary>
    ''' Ta procedura obsugi zdarzenia preinicjalizacyjnego jest uruchamiana w celu przeprowadzenia inicjalizacji. 
    ''' Pozwala ona okreli motyw i tytu strony, ktre s wydobywane z pliku 
    ''' web.config za porednictwem udostpnionych waciwoci wspuytkowanej klasy Config.
    ''' </summary>
    Protected Sub Page_PreInit(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.PreInit
        Page.Theme = Config.CurrentTheme
        Page.Title = Config.PageTitle
    End Sub

    ''' <summary>
    ''' Funkcja GetCallbackResult zwraca serwerowi odpowied
    ''' w postaci acucha ze znacznikami jzyka HTML
    ''' </summary>
    Public Function GetCallbackResult() As String Implements _
        System.Web.UI.ICallbackEventHandler.GetCallbackResult

        Dim Message As String
        Dim ds As DataSet = ChatRoom.GetMessagesForChatRoom( _
            Request.QueryString("chatRoomID"))
        For i As Integer = 0 To ds.Tables(0).Rows.Count - 1
            Message += "<b>" & ds.Tables(0).Rows(i)("Email").ToString() & _
                "</b> said: " & ds.Tables(0).Rows(i)("Text").ToString() & "<BR>"
        Next
        'odelij do formularza...
        Return Message & "<a name='bottom'></a><BR>"
    End Function

    ''' <summary>
    ''' Zdarzenie RaiseCallbackEvent pozostaje puste, jako miejsce  
    ''' na zdarzenie, ktre uruchomia si kiedy serwer przechwyci wywoanie zwrotne
    ''' </summary>
    Public Sub RaiseCallbackEvent(ByVal eventArgument As String) Implements System.Web.UI.ICallbackEventHandler.RaiseCallbackEvent
    End Sub

    ''' <summary>
    ''' Zdarzenie Page_Load event pozwala na osadzenie niezbdnego skryptu wywoania zwrotnego 
    ''' wewntrz javascript przegldarki 
    ''' </summary>
    Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Dim cm As ClientScriptManager = Page.ClientScript
        Dim cbReference As String
        cbReference = cm.GetCallbackEventReference(Me, "arg", _
            "ReceiveServerData", "")
        Dim callbackScript As String = ""
        callbackScript &= "function CallServer(arg, context)" & _
            "{" & cbReference & "; }"
        cm.RegisterClientScriptBlock(Me.GetType(), "CallServer", _
            callbackScript, True)


    End Sub

End Class
